﻿<%@ Page language="c#" codePage="1200" AutoEventWireup="false"%>

<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Ksiega" %>
<%@ Import Namespace="System.Collections.Generic" %>

<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>


<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
  <HEAD>
	<title>Zestawienie obrotów i sald</title>
	<script runat="server">
	ObrotyKontaWorker okw = null;
	
	void DataRepeater1_BeforeRow(object sender, EventArgs args) {
	  KontoBase k = (KontoBase)((DataRepeater)sender).CurrentRow;
	  labelSymbol.EditValue = k.Symbol;
	  labelNazwa.EditValue = k.Nazwa;
	  labelWaluta.EditValue = k.Waluta;
	  okw.Konto = k;
	  Grid1.DataSource = okw.Obroty;
	  
	  labelBOWn.EditValue = okw.BOWn;
	  labelBOMa.EditValue = okw.BOMa;     
	  labelSaldoBO.EditValue = okw.SaldoBO;           
	  
	  labelObrotyWn.EditValue = okw.ObrotyWn;
	  labelObrotyMa.EditValue = okw.ObrotyMa;      
	  
	  labelObrotyNWn.EditValue = okw.ObrotyNWn;
	  labelObrotyNMa.EditValue = okw.ObrotyNMa;
	  labelSaldoWn.EditValue = okw.SaldoWn;
	  labelSaldoMa.EditValue = okw.SaldoMa;      
	  labelPersaldo.EditValue = okw.PerSaldo;
	}
	
	void Grid1_BeforeRow(object sender, Soneta.Web.RowEventArgs args) {
	  ZapisKsiegowy z = (ZapisKsiegowy)args.Row;
	  colWinienOperacji.EditValue = 
		(z.Winien.Symbol==z.WinienOperacji.Symbol && z.Winien==z.WinienOperacji) ?
		"" : z.WinienOperacji.ToString();
	  colMaOperacji.EditValue = 
		(z.Ma.Symbol==z.MaOperacji.Symbol && z.Ma==z.MaOperacji) ?
		"" : z.MaOperacji.ToString();        
	}
	
	void ObrotyKonta_OnLoad(Object sender, EventArgs args){
	  okw = new ObrotyKontaWorker();
	  ObrotyKontaWorker.Params p  = (ObrotyKontaWorker.Params)DataContext1.Get(typeof(ObrotyKontaWorker.Params));
	  OkresObrachunkowy o         = (OkresObrachunkowy)DataContext1.Get(typeof(OkresObrachunkowy));
	  Konta.Params p1             = (Konta.Params)DataContext1.Get(typeof(Konta.Params));
	  okw.Param = p;
	  
	  ReportHeader1.Title = 
		string.Format(ReportHeader1.Title,
		 o, p.Okres,
		 p1.Typ, p1.Systematyka, p.Bufor ? "Tak" : "Nie", p.DekretyZamkniecia ? "Tak" : "Nie", CalcOpisNiezerowe(p1),
		 p1.Filtr, p1.OdKonta, p1.DoKonta);
	}



		private string CalcOpisNiezerowe(Konta.Params p1)
		{
			var items = new List<String>();

			if(p1.Niezerowe)
				items.Add("Niezerowe obroty");
			if(p1.NiezeroweSalda)
				items.Add("Niezerowe salda");
			if(p1.NiezeroweSaldaBO)
				items.Add("Niezerowe salda BO");

			if (items.Count == 0)
				return string.Empty;
			if (items.Count == 1)
				return "|" + items[0] + ": Tak";

			return "|" + string.Join(p1.NiezeroweCond == Konta.Params.NiezeroweWarunek.CondAnd ? " i ": " lub ", items);
		}



	Params param = null;
	[Context]
	public Params Param {
		set { param = value; }
	}

	public class Params : ContextBase{
		public Params(Context cx)
			: base(cx) {
		}

		 public ObrotyKontaWorker.Params.TypDziennika TypDziennika {
			get{ return ((ObrotyKontaWorker.Params)Context[typeof(ObrotyKontaWorker.Params)]).ObrotyTypDziennika; }
			set { ((ObrotyKontaWorker.Params)Context[typeof(ObrotyKontaWorker.Params)]).ObrotyTypDziennika = value; OnChanged(EventArgs.Empty); }
		}
	}   
	</script>
	
	<meta name="GENERATOR" Content="Microsoft Visual Studio 7.0">
	<meta name="CODE_LANGUAGE" Content="C#">
	<meta name="vs_defaultClientScript" content="JavaScript">
	<meta name="vs_targetSchema" content="http://schemas.microsoft.com/intellisense/ie5">
  </HEAD>
  <body>
	<form id="ObrotyKonta" method="post" onload="ObrotyKonta_OnLoad" runat="server">
	  <ea:DataContext id="DataContext1" runat="server" TypeName="Soneta.Business.Row[], Soneta.Business"></ea:DataContext><BR>
	  <cc1:ReportHeader id="ReportHeader1" title="Obroty konta | Okres obrachunkowy: {0}, Za okres: {1} | Typ kont: {2}, Systematyka: {3} | Uwzględniać bufor: {4} | Uwzględniać dekrety zamknięcia: {5}{6}| Filtr: {7} | Od konta: {8} | Do konta: {9}" runat="server"></cc1:ReportHeader><BR>
	  <ea:DataRepeater id="DataRepeater1" runat="server" RowTypeName="Soneta.Ksiega.KontoBase,Soneta.Ksiega" OnBeforeRow="DataRepeater1_BeforeRow">
		  <ea:SectionMarker id="SectionMarker1" runat="server" SectionType="Body"></ea:SectionMarker>
		  <TABLE width="100%" style="FONT-SIZE: x-small; FONT-FAMILY: Tahoma">
			<TR>
			  <TD align="left">
				<ea:DataLabel id="labelSymbol" runat="server" Font-Names="Tahoma" EncodeHTML="true" ></ea:DataLabel></TD>
			  <TD align="middle">
				<ea:DataLabel id="labelNazwa" runat="server" Font-Names="Tahoma" EncodeHTML="true" ></ea:DataLabel></TD>
			  <TD align="right">
				<ea:DataLabel id="labelWaluta" runat="server" Font-Names="Tahoma"></ea:DataLabel></TD>
			</TR>
		  </TABLE>
		  <HR noShade="true" SIZE="1">
		  <ea:SectionMarker id="SectionMarker2" runat="server" SectionType="Body"></ea:SectionMarker>
		  <ea:Grid id="Grid1" runat="server" OnBeforeRow="Grid1_BeforeRow" Sort="Dekret.Data,Dekret.Numer.Symbol,Dekret.ID,Lp" RowTypeName="Soneta.Ksiega.ZapisKsiegowy,Soneta.Ksiega" RowsInRow="2" _ShowPageSum="True" _ShowAgrSum="True" _ShowPrevAgrSum="InFooter">
			<Columns>
			  <ea:GridColumn Width="20" DataMember="Numer"  ID="colNumer"></ea:GridColumn>
			  <ea:GridColumn Width="20" Align="Center" DataMember="Data"  ID="colData"></ea:GridColumn>
			  <ea:GridColumn Width="20" DataMember="NumerEwidencji" Caption="Nr ewidencji"  ID="colNrEwidencji"></ea:GridColumn>
			  <ea:GridColumn Width="20" DataMember="NumerDokumentu" Caption="Nr dokumentu"  ID="colNrDokumentu" EncodeHTML="true"></ea:GridColumn>
			  <ea:GridColumn DataMember="Konto.Symbol" Caption="Konto"  ID="colSymbol" EncodeHTML="true" ></ea:GridColumn>
			  <ea:GridColumn DataMember="Opis" Total="Info"  ID="colOpis" EncodeHTML="true" ></ea:GridColumn>
			  <ea:GridColumn Width="20" Align="Right" DataMember="Winien.Value" Total="Sum" Caption="Winien"  HideZero="True" Format="{0:n}" ID="colWinien"></ea:GridColumn>
			  <ea:GridColumn Width="20" Align="Right" Caption="Winien operacji"  ID="colWinienOperacji"></ea:GridColumn>
			  <ea:GridColumn Width="20" Align="Right" DataMember="Ma.Value" Total="Sum" Caption="Ma"  HideZero="True" Format="{0:n}" ID="colMa"></ea:GridColumn>
			  <ea:GridColumn Width="20" Align="Right" Caption="Ma operacji"  ID="colMaOperacji"></ea:GridColumn>
			</Columns>
		  </ea:Grid>
		  <ea:SectionMarker id="Sectionmarker3" runat="server" SectionType="Body"></ea:SectionMarker>
		<HR noShade="true" SIZE="1" />
		<TABLE style="FONT-SIZE: xx-small; FONT-FAMILY: Tahoma" width="100%" border="1" cellspacing="0">
		  <col align="left"/>
		  <col align="right"/>
		  <col align="right"/>
		  <col align="right"/>
		  <col align="right"/>
		  <TR>
			<TD></TD>
			<TD align="middle">BO</TD>
			<TD align="middle">Obroty</TD>
			<TD align="middle">Obroty narastająco</TD>
			<TD align="middle">Saldo</TD>
		  </TR>
		  <TR>
			<TD>Winien</TD>
			<TD>
			  <ea:DataLabel id="labelBOWn" runat="server" Format="{0:n}"></ea:DataLabel></TD>
			<TD>
			  <ea:DataLabel id="labelObrotyWn" runat="server" Format="{0:n}"></ea:DataLabel></TD>
			<TD>
			  <ea:DataLabel id="labelObrotyNWn" runat="server" Format="{0:n}"></ea:DataLabel></TD>
			<TD>
			  <ea:DataLabel id="labelSaldoWn" runat="server" Format="{0:n}"></ea:DataLabel></TD>
		  </TR>
		  <TR>
			<TD>Ma</TD>
			<TD>
			  <ea:DataLabel id="labelBOMa" runat="server" Format="{0:n}"></ea:DataLabel></TD>
			<TD>
			  <ea:DataLabel id="labelObrotyMa" runat="server" Format="{0:n}"></ea:DataLabel></TD>
			<TD>
			  <ea:DataLabel id="labelObrotyNMa" runat="server" Format="{0:n}"></ea:DataLabel></TD>
			<TD>
			  <ea:DataLabel id="labelSaldoMa" runat="server" Format="{0:n}"></ea:DataLabel></TD>
		  </TR>
		  <TR>
			<TD>Persaldo</TD>
			<TD>
			  <ea:DataLabel id="labelSaldoBO" runat="server" Format="{0:n}"></ea:DataLabel></TD>
			<TD></TD>
			<TD></TD>
			<TD>
			  <ea:DataLabel id="labelPersaldo" runat="server" Format="{0:n}"></ea:DataLabel></TD>
		  </TR>
		</TABLE>
	  </ea:DataRepeater>
	  <cc1:ReportFooter id="ReportFooter1" runat="server">
		<Subtitles>
		  <cc1:FooterSubtitle SubtitleType="Operator"></cc1:FooterSubtitle>
		</Subtitles>
	  </cc1:ReportFooter>
	</form>
  </body>
</HTML>

